package dotsandboxes;

import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.*;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DotsAndBoxesGridTest {
    /*
     * Because Test classes are classes, they can have fields, and can have static
     * fields.
     * This field is a logger. Loggers are like a more advanced println, for writing
     * messages out to the console or a log file.
     */
    private static final Logger logger = LogManager.getLogger(DotsAndBoxesGridTest.class);
    private DotsAndBoxesGrid gridTest;

    /*
     * Tests are functions that have an @Test annotation before them.
     * The typical format of a test is that it contains some code that does
     * something, and then one
     * or more assertions to check that a condition holds.
     *
     * This is a dummy test just to show that the test suite itself runs
     */
    public void setUp() {
        // Setting up a new DotsAndBoxesGrid for every test
        gridTest = new DotsAndBoxesGrid(4, 4, 2);
    }

    @Test
    public void testTestSuiteRuns() {
        logger.info("Dummy test to show the test suite runs");
        assertTrue(true);
    }

    // FIXME: You need to write tests for the two known bugs in the code.
    @Test
    public void testScoreCalculation() {
        logger.info("Testing score calculation on box completion");

        DotsAndBoxesGrid grid = new DotsAndBoxesGrid(4, 3, 2);
        grid.drawHorizontal(0, 0, 1);
        grid.drawVertical(0, 0, 1);
        grid.drawVertical(1, 0, 1);
        boolean boxCompleted = grid.drawHorizontal(1, 0, 1); // This should complete the box

        // Check if the box was completed and claimed by the correct player
        assertTrue(boxCompleted, "Box should be completed and claimed");
        assertEquals(1, grid.getBoxOwner(0, 0), "The box owner should be player 1");
    }

    @Test
    public void testInvalidMoveHandling() {
        logger.info("Testing invalid move handling");

        DotsAndBoxesGrid grid = new DotsAndBoxesGrid(4, 3, 2);
        grid.drawHorizontal(0, 0, 1);
        // Attempt to draw the same horizontal line again
        Exception exception = assertThrows(IndexOutOfBoundsException.class, () -> {
            grid.drawHorizontal(0, 0, 1); // This should throw an exception
        });

        assertEquals("Line has already been drawn", exception.getMessage());
    }

    @Test
    public void testBoxCompletionLogic() {
        logger.info("Testing box completion logic");

        DotsAndBoxesGrid grid = new DotsAndBoxesGrid(4, 3, 2);
        // Attempt to complete a box without drawing all lines
        boolean isComplete = grid.boxComplete(0, 0);
        assertFalse(isComplete, "Box should not be complete without all lines drawn");
    }
}
