package dotsandboxes;

import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.*;
import static org.junit.jupiter.api.Assumptions.*;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DotsAndBoxesGridTest {
    /*
     * Because Test classes are classes, they can have fields, and can have static
     * fields.
     * This field is a logger. Loggers are like a more advanced println, for writing
     * messages out to the console or a log file.
     */
    private static final Logger logger = LogManager.getLogger(DotsAndBoxesGridTest.class);

    /*
     * Tests are functions that have an @Test annotation before them.
     * The typical format of a test is that it contains some code that does
     * something, and then one
     * or more assertions to check that a condition holds.
     *
     * This is a dummy test just to show that the test suite itself runs
     */
    @Test
    public void testTestSuiteRuns() {
        logger.info("Dummy test to show the test suite runs");
        assertTrue(true);
    }

    // FIXME: You need to write tests for the two known bugs in the code.
    @Test
    public void testCompleteBox() {
        logger.info("Testing whether the algorithm for testing whether a box is complete is wrong");

        DotsAndBoxesGrid grid = new DotsAndBoxesGrid(1, 1, 2);

        // draw three sides of a box, not four!
        grid.drawVertical(0, 0, 1);
        grid.drawVertical(1, 0, 1);
        grid.drawHorizontal(0, 0, 1);

        assertFalse(grid.boxComplete(1, 0));
    }

    @Test
    public void testHorizontalAlreadyDrawn() {
        logger.info("Testing whether an exception is thrown if a horizontal line is already drawn.");

        DotsAndBoxesGrid grid = new DotsAndBoxesGrid(15, 8, 2);

        grid.drawHorizontal(1, 1, 1);
        Exception exeption = assertThrows(IllegalStateException.class, () -> {
            grid.drawHorizontal(1, 1, 1);
        });

        String expectedMessage = "Horizontal line already drawn";
        String actualMessage = exeption.getMessage();

        assertTrue(actualMessage.contains(expectedMessage));
    }

    @Test
    public void testVerticalAlreadyDrawn() {
        logger.info("Testing whether an exception is thrown if a horizontal line is already drawn.");

        DotsAndBoxesGrid grid = new DotsAndBoxesGrid(15, 8, 2);

        grid.drawVertical(1, 1, 1);
        Exception exeption = assertThrows(IllegalStateException.class, () -> {
            grid.drawVertical(1, 1, 1);
        });

        String expectedMessage = "Vertical line already drawn";
        String actualMessage = exeption.getMessage();

        assertTrue(actualMessage.contains(expectedMessage));
    }
}
