package dotsandboxes;

import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.*;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DotsAndBoxesGridTest {
    private static final Logger logger = LogManager.getLogger(DotsAndBoxesGridTest.class);

    @Test
    public void testTestSuiteRuns() {
        logger.info("Dummy test to show the test suite runs");
        assertTrue(true);
    }

    // Test for Bug 1: Check if a square is correctly marked as complete
    @Test
    public void testSquareCompletion() {
        logger.info("Testing square completion logic");
        DotsAndBoxesGrid game = new DotsAndBoxesGrid(4, 4, 2);
        
        // Simulate drawing lines to complete a square
        game.drawHorizontal(0, 0, 1);
        game.drawHorizontal(0, 1, 1);
        game.drawVertical(0, 0, 1);
        game.drawVertical(1, 0, 1);
        
        // Assert that the square is marked as complete
        assertTrue(game.boxComplete(0, 0), "Square should be complete");
    }

    // Test for Bug 2: Check if an exception is thrown when a line is drawn twice
    @Test
    public void testDrawingLineTwice() {
        logger.info("Testing drawing the same line twice");
        DotsAndBoxesGrid game = new DotsAndBoxesGrid(4, 4, 2);
        
        // Draw the same line twice and expect an exception
        game.drawHorizontal(0, 0, 1);
        assertThrows(IllegalStateException.class, () -> game.drawHorizontal(0, 0, 1), "Drawing the same line twice should throw an exception");
    }
}
