package controllers

import javax.inject._

import scala.util.Random

import play.api.libs.json.{JsValue, Json}
import play.api.mvc._


@Singleton
class ExamplesController @Inject()(cc: ControllerComponents) extends AbstractController(cc) {

  /**
    * A controller action that receives JSON as input.
    * The bodyParser parses the content for you, and leaves the parsed JSON in req.body
    *
    * @return
    */
  def receiveJsonPost():Action[JsValue] = Action(bodyParser = parse.json) { req =>

    val json:JsValue = req.body

    /*
     * If the JSON is { name: "Fred" }
     * then this gets the value that's in name
     */
    val name = (json \ "name").as[String]

    Ok(s"Hello $name")
  }

  /**
    * A controller that outputs some JSON
    * @return
    */
  def returnJson():Action[AnyContent] = Action { req =>

    Ok(Json.obj(
      "Hello" -> Seq("World", "Bob", "Alice"),
      "Goodbye" -> Json.obj(
        "Mr" -> "Chips"
      )
    ))
  }

  /**
    * A controller that takes an optional id in the query string.
    * If we get an ID, we return it. If not, we're just allocating a random ID and then
    * redirecting so we have an ID.
    * @param id
    * @return
    */
  def game(id:Option[String]) = Action { req =>

    def randomId = Random.alphanumeric.take(8).toString

    id match {
      case Some(s) => Ok(s"It was $s")
      case None => Redirect("/examples/call", Map("id" -> Seq(randomId)))
    }

  }

}
